#include <algorithm>
#include <bit>
#include <cmath>
#include <cstdint>
#include <ctime>
#include <fstream>
#include <functional>
#include <iomanip>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>

#include <array>
#include <bitset>
#include <list>
#include <map>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <vector>

#include <bit>

using namespace std;

using ll = int64_t;
using ull = uint64_t;
using ld = long double;
using pll = pair<ll, ll>;
using pii = pair<int, int>;

constexpr auto nl = "\n";

class mst
{
private:
    vector<vector<int>> t;
    int p;
public:
    mst (const vector<int>& v)
    {
        p = bit_ceil(size(v));
        t.assign(p * 2, {});
        for (int i = 0; i < size(v); ++i)
        {
            t[p + i] = {v[i]};
        }
        for (int i = p - 1; i; --i)
        {
            const vector<int>& l = t[i * 2 + 0], r = t[i * 2 + 1];
            t[i].resize(size(l) + size(r));
            merge(begin(l), end(l), begin(r), end(r), begin(t[i]));
        }
    }
    int get (int l, int r, int cl = 0, int cr = -1, int c = 1)
    {
        if (cr == -1)
        {
            cr = p;
        }

        if (cr <= l or r <= cl)
        {
            return 0;
        }
        if (l <= cl and cr <= r)
        {
            return end(t[c]) - lower_bound(begin(t[c]), end(t[c]), r);
        }
        int cm = (cl + cr) / 2;
        return
            get(l, r, cl, cm, c * 2 + 0) +
            get(l, r, cm, cr, c * 2 + 1);
    }
};

void solve()
{
    int n, m;
    cin >> n >> m;
    vector<int> a(m), b(n);
    for (int& x : a)
    {
        cin >> x;
    }
    for (int& x : b)
    {
        cin >> x;
    }
    vector<int> ans, last(n + 1, -1), next, v;
    int cur = 0;
    for (int i = 0; i < m; ++i)
    {
        if (last[a[i]] != -1)
        {
            next[last[a[i]]] = size(next);
        }
        else
        {
            while (b[cur] != a[i])
            {
                v.push_back(b[cur]);
                last[b[cur++]] = size(next);
                next.push_back(1e9);
            }
            ++cur;
        }
        v.push_back(a[i]);
        last[a[i]] = size(next);
        next.push_back(1e9);
    }
    last.assign(n + 1, -1);
    mst mst(next);
    ans.assign(size(next), n);
    for (int i = 0; i < size(v); ++i)
    {
        if (last[v[i]] != -1)
        {
            ans[last[v[i]]] = mst.get(last[v[i]], i) + 1;
        }
        last[v[i]] = i;
    }
    cout << size(ans) << nl;
    for (int x : ans)
    {
        cout << x << " ";
    }
    cout << nl;
}

void init ()
{
    
}

constexpr bool multitest = false;

int main()
{
    ios::sync_with_stdio(false), cin.tie(nullptr);

    int t = 1;
    if (multitest)
        cin >> t;

    init();
    while (t--)
        solve();
}

//  /\_/\
// (= ._.)
// / >  \>