#include <algorithm>
#include <bit>
#include <cmath>
#include <cstdint>
#include <ctime>
#include <fstream>
#include <functional>
#include <iomanip>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>

#include <array>
#include <bitset>
#include <list>
#include <map>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <vector>

#include <bit>

using namespace std;

using ll = int64_t;
using ull = uint64_t;
using ld = long double;
using pll = pair<ll, ll>;
using pii = pair<int, int>;

constexpr auto nl = "\n";

ll sm = 0;
class segt
{
    struct Node
    {
        vector<vector<ll>> m;
        int sz;
        Node () : m(4, vector<ll>(4, 1e18)), sz(0)
        {
        }
        Node (ll x) : m(4, vector<ll>(4, 1e18)), sz(1)
        {
            m[0][0] = x;
        }
    };
    vector<Node> t;
    int p;

    Node comb (const Node& a, const Node& b)
    {
        Node res;

        for (int l = 0; l < 4; ++l)
        {
            for (int r = 0; r < 4; ++r)
            {
                for (int i = 0; i < 4; ++i)
                {
                    for (int j = 0; j < 4 - i; ++j)
                    {
                        res.m[l][r] = min(res.m[l][r], a.m[l][i] + b.m[j][r]);
                    }
                }
            }
        }
        for (int i = 0; i < 4; ++i)
        {
            for (int j = 0; j < 4; ++j)
            {
                if (a.sz + i < 4)
                {
                    res.m[a.sz + i][j] = min(res.m[a.sz + i][j], b.m[i][j]);
                }
                if (j + b.sz < 4)
                {
                    res.m[i][j + b.sz] = min(res.m[i][j + b.sz], a.m[i][j]);
                }
            }
        }
        res.sz = a.sz + b.sz;

        return res;
    }

    Node get (int l, int r, int cl = 0, int cr = -1, int c = 1)
    {
        if (cr == -1)
        {
            cr = p;
        }
        if (l <= cl and cr <= r)
        {
            return t[c];
        }
        if (cr <= l or r <= cl)
        {
            return Node();
        }
        int cm = (cl + cr) / 2;
        return comb
        (
            get(l, r, cl, cm, c * 2 + 0),
            get(l, r, cm, cr, c * 2 + 1)
        );
    }
public:
    segt (int n)
    {
        p = bit_ceil(size_t(n));
        t.assign(2 * p, Node());
        for (int i = 0; i < n; ++i)
        {
            ll x;
            cin >> x;
            sm += x;
            t[p + i] = Node(x);
        }
        for (int i = p - 1; i; --i)
        {
            t[i] = comb(t[i * 2 + 0], t[i * 2 + 1]);
        }
    }
    ll get ()
    {
        Node res = get(0, p);
        ll ans = 2e18;
        for (int i = 0; i < 3; ++i)
        {
            for (int j = 0; j < 4 - i; ++j)
            {
                ans = min(ans, res.m[i][j]);
            }
        }
        return sm - ans;
    }
    void set (int i, ll x)
    {
        sm += x - t[p + i].m[0][0];
        t[p + i] = Node(x);
        for (int cur = (p + i) / 2; cur; cur /= 2)
        {
            t[cur] = comb(t[cur * 2 + 0], t[cur * 2 + 1]);
        }
    }
};

void solve()
{
    int n;
    cin >> n;
    segt st(n);
    cout << st.get() << nl;
    int q;
    cin >> q;
    while (q--)
    {
        int i, x;
        cin >> i >> x;
        st.set(i - 1, x);
        cout << st.get() << nl;
    }
}

void init ()
{

}

constexpr bool multitest = false;

int main()
{
    ios::sync_with_stdio(false), cin.tie(nullptr);

    int t = 1;
    if (multitest)
        cin >> t;

    init();
    while (t--)
        solve();
}

//  /\_/\
// (= ._.)
// / >  \>