#include <algorithm>
#include <bit>
#include <cmath>
#include <cstdint>
#include <ctime>
#include <fstream>
#include <functional>
#include <iomanip>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>

#include <array>
#include <bitset>
#include <list>
#include <map>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <complex>

using namespace std;

using ll = int64_t;
using ull = uint64_t;
using ld = long double;
using pll = pair<ll, ll>;
using pii = pair<int, int>;

constexpr auto nl = "\n";

void solve()
{
    int n;
    cin >> n;
    vector<int> v(n);
    for (int& x : v)
    {
        cin >> x;
    }
    vector<int> dp(n);
    dp[0] = 1;
    for (int i = 1; i < n; ++i)
    {
        int mx = 0;
        for (int j = i - 1; j >= 0; --j)
        {
            if (v[j] < v[i])
            {
                mx = max(mx, dp[j]);
                break;
            }
        }
        dp[i] = mx + 1;
    }
    int cur = 0;
    for (int i = 0; i < n; ++i)
    {
        if (dp[i] > dp[cur])
        {
            cur = i;
        }
    }
    vector<int> ans;
    while (true)
    {
        ans.push_back(v[cur]);
        for (int i = cur - 1; ; --i)
        {
            if (i == -1)
            {
                reverse(begin(ans), end(ans));
                cout << size(ans) << nl;
                for (int x : ans)
                {
                    cout << x << " ";
                }
                return;
            }
            if (v[i] < v[cur] and dp[i] == dp[cur] - 1)
            {
                cur = i;
                break;
            }
        }
    }
    
}


void init ()
{
    
}

constexpr bool multitest = false;

int main()
{
    ios::sync_with_stdio(false), cin.tie(nullptr);

    int t = 1;
    if (multitest)
        cin >> t;

    init();
    while (t--)
        solve();
}

//  /\_/\
// (= ._.)
// / >  \>