#include <algorithm>
#include <bit>
#include <cmath>
#include <cstdint>
#include <ctime>
#include <fstream>
#include <functional>
#include <iomanip>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>

#include <array>
#include <bitset>
#include <list>
#include <map>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <tuple>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <complex>

using namespace std;

using ll = int64_t;
using ull = uint64_t;
using ld = long double;
using pll = pair<ll, ll>;
using pii = pair<int, int>;

constexpr auto nl = "\n";

void solve()
{
    int n;
    cin >> n;
    vector<vector<int>> graph(n);
    for (int i = 1; i < n; ++i)
    {
        int x;
        cin >> x;
        --x;
        graph[x].push_back(i);
    }
    vector<int> a(n);
    for (int& x : a)
    {
        cin >> x;
    }
    function<int(int)> dfs = [&](int cur) -> int
    {
        int mx = 0, mx1 = -1, mx2 = -1;
        for (int next : graph[cur])
        {
            int x = dfs(next);
            if (x >= mx1)
            {
                mx2 = mx1;
                mx1 = x;
            }
            else if (x >= mx2)
            {
                mx2 = x;
            }
            if (a[cur] == 0 and mx2 != -1)
            {
                a[cur] = mx1 + mx2;
            }
        }
        return max(mx, a[cur]);
    };
    dfs(0);
    cout << accumulate(begin(a), end(a), 0) << nl;
}


void init ()
{
    
}

constexpr bool multitest = false;

int main()
{
    ios::sync_with_stdio(false), cin.tie(nullptr);

    int t = 1;
    if (multitest)
        cin >> t;

    init();
    while (t--)
        solve();
}

//  /\_/\
// (= ._.)
// / >  \>