#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <unordered_map>
#include <bitset>

using namespace std;
using ll = long long;

#define all(u) u.begin(), u.end()

const int MAXN = 3000;

vector <int> g[MAXN];
int match[MAXN];
vector <char> used;

bool dfs(int u) {
	  if (used[u]) {
			return 0;
	  }
	  used[u] = 1;
	  for (auto& v : g[u]) {
			if (match[v] == -1 or dfs(match[v])) {
				  match[v] = u;
				  return 1;
			}
	  }
	  return 0;
}

void solve() {
	  int n, m; cin >> n >> m;
	  for (int i = 0; i < n; ++i) {
	        match[i] = -1;
			while (true) {
				  int v; cin >> v;
				  v--;
				  if (v == -1) break;
				  g[i].push_back(v);
			}
	  }
	  for (int i = 0; i < n; ++i) {
			used.assign(n, 0);
			dfs(i);
	  }
	  vector <pair<int, int>> ans;
	  for (int i = 0; i < m; ++i) {
			if (match[i] != -1) {
				  ans.push_back({ i, match[i] });
			}
	  }
	  cout << ans.size() << '\n';
	  for (auto& i : ans) {
			cout << i.second+ 1 << " " << i.first + 1 << '\n';
	  }
}
bool multitest = 0;

signed main() {
	  ios_base::sync_with_stdio(0);
	  cin.tie(nullptr);
	  int t = 1; if (multitest) cin >> t;
	  while (t--) solve();
}