#include <iostream>
#include <string>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <bitset>
#include <unordered_map>

using namespace std;
using ll = long long;

#define FOR(i, a, b) for (ll i = ll(a);i < ll(b);i++)
#define all(a) begin(a), end(a)

const ll mod = 1e9 + 7;

vector <int> z_f(string s) {
    int n = s.size();
    vector <int> z(n);
    int l = 0, r = 0;
    for (int i = 1; i < n; ++i) {
        if (i <= r) {
            z[i] = min(r - i, z[i - l] + 3);
        }
        while (i + z[i] < n and s[z[i]] == s[i + z[i]]) {
            z[i]++;
        }
        if (r < i + z[i]) {
            r = i + z[i];
            l = i;
        }
    }
    return z;
}

void solve() {
    string s; cin >> s;
    int n = s.size();
    vector <int> ans(n), z = z_f(s);
    int ind = 0;
    string cur;
    for (; ind < n; ++ind) {
        cur += s[ind];
        if (ans[ind]) continue;
        ans[ind] = ind + 1;
        for (int i = cur.size(); i < n and i + cur.size() - 1 < n; i += cur.size()) {
            if (z[i] >= cur.size()) {
                ans[i + cur.size() - 1] = cur.size();
            }
            else break;
        }
    }
    int res = 0;
    for (int i = 0; i < n; ++i) res ^= ans[i];
    cout << res;
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0); cout.tie(0);
    solve();
}